/*
 * This declarations of the PIC16LF1906 MCU.
 *
 * This file is part of the GNU PIC library for SDCC, originally
 * created by Molnar Karoly <molnarkaroly@users.sf.net> 2012.
 *
 * This file is generated automatically by the cinc2h.pl, 2012-11-01 17:30:24 UTC.
 *
 * SDCC is licensed under the GNU Public license (GPL) v2. Note that
 * this license covers the code to the compiler and other executables,
 * but explicitly does not cover any code or objects generated by sdcc.
 *
 * For pic device libraries and header files which are derived from
 * Microchip header (.inc) and linker script (.lkr) files Microchip
 * requires that "The header files should state that they are only to be
 * used with authentic Microchip devices" which makes them incompatible
 * with the GPL. Pic device libraries and header files are located at
 * non-free/lib and non-free/include directories respectively.
 * Sdcc should be run with the --use-non-free command line option in
 * order to include non-free header files and libraries.
 *
 * See http://sdcc.sourceforge.net/ for the latest information on sdcc.
 */

#ifndef __PIC16LF1906_H__
#define __PIC16LF1906_H__

//==============================================================================
//
//	Register Addresses
//
//==============================================================================

#ifndef NO_ADDR_DEFINES

#define INDF0_ADDR              0x0000
#define INDF1_ADDR              0x0001
#define PCL_ADDR                0x0002
#define STATUS_ADDR             0x0003
#define FSR0_ADDR               0x0004
#define FSR0L_ADDR              0x0004
#define FSR0H_ADDR              0x0005
#define FSR1_ADDR               0x0006
#define FSR1L_ADDR              0x0006
#define FSR1H_ADDR              0x0007
#define BSR_ADDR                0x0008
#define WREG_ADDR               0x0009
#define PCLATH_ADDR             0x000A
#define INTCON_ADDR             0x000B
#define PORTA_ADDR              0x000C
#define PORTB_ADDR              0x000D
#define PORTC_ADDR              0x000E
#define PORTE_ADDR              0x0010
#define PIR1_ADDR               0x0011
#define PIR2_ADDR               0x0012
#define TMR0_ADDR               0x0015
#define TMR1_ADDR               0x0016
#define TMR1L_ADDR              0x0016
#define TMR1H_ADDR              0x0017
#define T1CON_ADDR              0x0018
#define T1GCON_ADDR             0x0019
#define TRISA_ADDR              0x008C
#define TRISB_ADDR              0x008D
#define TRISC_ADDR              0x008E
#define TRISE_ADDR              0x0090
#define PIE1_ADDR               0x0091
#define PIE2_ADDR               0x0092
#define OPTION_REG_ADDR         0x0095
#define PCON_ADDR               0x0096
#define WDTCON_ADDR             0x0097
#define OSCCON_ADDR             0x0099
#define OSCSTAT_ADDR            0x009A
#define ADRES_ADDR              0x009B
#define ADRESL_ADDR             0x009B
#define ADRESH_ADDR             0x009C
#define ADCON0_ADDR             0x009D
#define ADCON1_ADDR             0x009E
#define LATA_ADDR               0x010C
#define LATB_ADDR               0x010D
#define LATC_ADDR               0x010E
#define BORCON_ADDR             0x0116
#define FVRCON_ADDR             0x0117
#define ANSELA_ADDR             0x018C
#define ANSELB_ADDR             0x018D
#define PMADR_ADDR              0x0191
#define PMADRL_ADDR             0x0191
#define PMADRH_ADDR             0x0192
#define PMDAT_ADDR              0x0193
#define PMDATL_ADDR             0x0193
#define PMDATH_ADDR             0x0194
#define PMCON1_ADDR             0x0195
#define PMCON2_ADDR             0x0196
#define RC1REG_ADDR             0x0199
#define RCREG_ADDR              0x0199
#define RCREG1_ADDR             0x0199
#define TX1REG_ADDR             0x019A
#define TXREG_ADDR              0x019A
#define TXREG1_ADDR             0x019A
#define SP1BRGL_ADDR            0x019B
#define SPBRG_ADDR              0x019B
#define SPBRGL_ADDR             0x019B
#define SPBRGL1_ADDR            0x019B
#define SP1BRGH_ADDR            0x019C
#define SPBRGH_ADDR             0x019C
#define SPBRGH1_ADDR            0x019C
#define RC1STA_ADDR             0x019D
#define RCSTA_ADDR              0x019D
#define RCSTA1_ADDR             0x019D
#define TX1STA_ADDR             0x019E
#define TXSTA_ADDR              0x019E
#define TXSTA1_ADDR             0x019E
#define BAUD1CON_ADDR           0x019F
#define BAUDCON_ADDR            0x019F
#define BAUDCON1_ADDR           0x019F
#define WPUB_ADDR               0x020D
#define WPUE_ADDR               0x0210
#define IOCBP_ADDR              0x0394
#define IOCBN_ADDR              0x0395
#define IOCBF_ADDR              0x0396
#define LCDCON_ADDR             0x0791
#define LCDPS_ADDR              0x0792
#define LCDREF_ADDR             0x0793
#define LCDCST_ADDR             0x0794
#define LCDRL_ADDR              0x0795
#define LCDSE0_ADDR             0x0798
#define LCDSE1_ADDR             0x0799
#define LCDSE3_ADDR             0x079B
#define LCDDATA0_ADDR           0x07A0
#define LCDDATA1_ADDR           0x07A1
#define LCDDATA3_ADDR           0x07A3
#define LCDDATA4_ADDR           0x07A4
#define LCDDATA6_ADDR           0x07A6
#define LCDDATA7_ADDR           0x07A7
#define LCDDATA9_ADDR           0x07A9
#define LCDDATA10_ADDR          0x07AA
#define LCDDATA12_ADDR          0x07AC
#define LCDDATA15_ADDR          0x07AF
#define LCDDATA18_ADDR          0x07B2
#define LCDDATA21_ADDR          0x07B5
#define STATUS_SHAD_ADDR        0x0FE4
#define WREG_SHAD_ADDR          0x0FE5
#define BSR_SHAD_ADDR           0x0FE6
#define PCLATH_SHAD_ADDR        0x0FE7
#define FSR0L_SHAD_ADDR         0x0FE8
#define FSR0H_SHAD_ADDR         0x0FE9
#define FSR1L_SHAD_ADDR         0x0FEA
#define FSR1H_SHAD_ADDR         0x0FEB
#define STKPTR_ADDR             0x0FED
#define TOSL_ADDR               0x0FEE
#define TOSH_ADDR               0x0FEF

#endif // #ifndef NO_ADDR_DEFINES

//==============================================================================
//
//	Register Definitions
//
//==============================================================================

extern __at(0x0000) __sfr INDF0;
extern __at(0x0001) __sfr INDF1;
extern __at(0x0002) __sfr PCL;

//==============================================================================
//        STATUS Bits

extern __at(0x0003) __sfr STATUS;

typedef struct
  {
  unsigned C                    : 1;
  unsigned DC                   : 1;
  unsigned Z                    : 1;
  unsigned NOT_PD               : 1;
  unsigned NOT_TO               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUSbits_t;

extern __at(0x0003) volatile __STATUSbits_t STATUSbits;

#define _C                      0x01
#define _DC                     0x02
#define _Z                      0x04
#define _NOT_PD                 0x08
#define _NOT_TO                 0x10

//==============================================================================

extern __at(0x0004) __sfr FSR0;
extern __at(0x0004) __sfr FSR0L;
extern __at(0x0005) __sfr FSR0H;
extern __at(0x0006) __sfr FSR1;
extern __at(0x0006) __sfr FSR1L;
extern __at(0x0007) __sfr FSR1H;

//==============================================================================
//        BSR Bits

extern __at(0x0008) __sfr BSR;

typedef union
  {
  struct
    {
    unsigned BSR0               : 1;
    unsigned BSR1               : 1;
    unsigned BSR2               : 1;
    unsigned BSR3               : 1;
    unsigned BSR4               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned BSR                : 5;
    unsigned                    : 3;
    };
  } __BSRbits_t;

extern __at(0x0008) volatile __BSRbits_t BSRbits;

#define _BSR0                   0x01
#define _BSR1                   0x02
#define _BSR2                   0x04
#define _BSR3                   0x08
#define _BSR4                   0x10

//==============================================================================

extern __at(0x0009) __sfr WREG;
extern __at(0x000A) __sfr PCLATH;

//==============================================================================
//        INTCON Bits

extern __at(0x000B) __sfr INTCON;

typedef union
  {
  struct
    {
    unsigned IOCIF              : 1;
    unsigned INTF               : 1;
    unsigned TMR0IF             : 1;
    unsigned IOCIE              : 1;
    unsigned INTE               : 1;
    unsigned TMR0IE             : 1;
    unsigned PEIE               : 1;
    unsigned GIE                : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IF               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0IE               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };
  } __INTCONbits_t;

extern __at(0x000B) volatile __INTCONbits_t INTCONbits;

#define _IOCIF                  0x01
#define _INTF                   0x02
#define _TMR0IF                 0x04
#define _T0IF                   0x04
#define _IOCIE                  0x08
#define _INTE                   0x10
#define _TMR0IE                 0x20
#define _T0IE                   0x20
#define _PEIE                   0x40
#define _GIE                    0x80

//==============================================================================


//==============================================================================
//        PORTA Bits

extern __at(0x000C) __sfr PORTA;

typedef struct
  {
  unsigned RA0                  : 1;
  unsigned RA1                  : 1;
  unsigned RA2                  : 1;
  unsigned RA3                  : 1;
  unsigned RA4                  : 1;
  unsigned RA5                  : 1;
  unsigned RA6                  : 1;
  unsigned RA7                  : 1;
  } __PORTAbits_t;

extern __at(0x000C) volatile __PORTAbits_t PORTAbits;

#define _RA0                    0x01
#define _RA1                    0x02
#define _RA2                    0x04
#define _RA3                    0x08
#define _RA4                    0x10
#define _RA5                    0x20
#define _RA6                    0x40
#define _RA7                    0x80

//==============================================================================


//==============================================================================
//        PORTB Bits

extern __at(0x000D) __sfr PORTB;

typedef struct
  {
  unsigned RB0                  : 1;
  unsigned RB1                  : 1;
  unsigned RB2                  : 1;
  unsigned RB3                  : 1;
  unsigned RB4                  : 1;
  unsigned RB5                  : 1;
  unsigned RB6                  : 1;
  unsigned RB7                  : 1;
  } __PORTBbits_t;

extern __at(0x000D) volatile __PORTBbits_t PORTBbits;

#define _RB0                    0x01
#define _RB1                    0x02
#define _RB2                    0x04
#define _RB3                    0x08
#define _RB4                    0x10
#define _RB5                    0x20
#define _RB6                    0x40
#define _RB7                    0x80

//==============================================================================


//==============================================================================
//        PORTC Bits

extern __at(0x000E) __sfr PORTC;

typedef struct
  {
  unsigned RC0                  : 1;
  unsigned RC1                  : 1;
  unsigned RC2                  : 1;
  unsigned RC3                  : 1;
  unsigned RC4                  : 1;
  unsigned RC5                  : 1;
  unsigned RC6                  : 1;
  unsigned RC7                  : 1;
  } __PORTCbits_t;

extern __at(0x000E) volatile __PORTCbits_t PORTCbits;

#define _RC0                    0x01
#define _RC1                    0x02
#define _RC2                    0x04
#define _RC3                    0x08
#define _RC4                    0x10
#define _RC5                    0x20
#define _RC6                    0x40
#define _RC7                    0x80

//==============================================================================


//==============================================================================
//        PORTE Bits

extern __at(0x0010) __sfr PORTE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned RE3                  : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PORTEbits_t;

extern __at(0x0010) volatile __PORTEbits_t PORTEbits;

#define _RE3                    0x08

//==============================================================================


//==============================================================================
//        PIR1 Bits

extern __at(0x0011) __sfr PIR1;

typedef struct
  {
  unsigned TMR1IF               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TXIF                 : 1;
  unsigned RCIF                 : 1;
  unsigned ADIF                 : 1;
  unsigned TMR1GIF              : 1;
  } __PIR1bits_t;

extern __at(0x0011) volatile __PIR1bits_t PIR1bits;

#define _TMR1IF                 0x01
#define _TXIF                   0x10
#define _RCIF                   0x20
#define _ADIF                   0x40
#define _TMR1GIF                0x80

//==============================================================================


//==============================================================================
//        PIR2 Bits

extern __at(0x0012) __sfr PIR2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LCDIF                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIR2bits_t;

extern __at(0x0012) volatile __PIR2bits_t PIR2bits;

#define _LCDIF                  0x04

//==============================================================================

extern __at(0x0015) __sfr TMR0;
extern __at(0x0016) __sfr TMR1;
extern __at(0x0016) __sfr TMR1L;
extern __at(0x0017) __sfr TMR1H;

//==============================================================================
//        T1CON Bits

extern __at(0x0018) __sfr T1CON;

typedef union
  {
  struct
    {
    unsigned TMR1ON             : 1;
    unsigned                    : 1;
    unsigned NOT_T1SYNC         : 1;
    unsigned T1OSCEN            : 1;
    unsigned T1CKPS0            : 1;
    unsigned T1CKPS1            : 1;
    unsigned TMR1CS0            : 1;
    unsigned TMR1CS1            : 1;
    };

  struct
    {
    unsigned                    : 4;
    unsigned T1CKPS             : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned TMR1CS             : 2;
    };
  } __T1CONbits_t;

extern __at(0x0018) volatile __T1CONbits_t T1CONbits;

#define _TMR1ON                 0x01
#define _NOT_T1SYNC             0x04
#define _T1OSCEN                0x08
#define _T1CKPS0                0x10
#define _T1CKPS1                0x20
#define _TMR1CS0                0x40
#define _TMR1CS1                0x80

//==============================================================================


//==============================================================================
//        T1GCON Bits

extern __at(0x0019) __sfr T1GCON;

typedef union
  {
  struct
    {
    unsigned T1GSS0             : 1;
    unsigned T1GSS1             : 1;
    unsigned T1GVAL             : 1;
    unsigned T1GGO_NOT_DONE     : 1;
    unsigned T1GSPM             : 1;
    unsigned T1GTM              : 1;
    unsigned T1GPOL             : 1;
    unsigned TMR1GE             : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T1GGO              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned T1GSS              : 2;
    unsigned                    : 6;
    };
  } __T1GCONbits_t;

extern __at(0x0019) volatile __T1GCONbits_t T1GCONbits;

#define _T1GSS0                 0x01
#define _T1GSS1                 0x02
#define _T1GVAL                 0x04
#define _T1GGO_NOT_DONE         0x08
#define _T1GGO                  0x08
#define _T1GSPM                 0x10
#define _T1GTM                  0x20
#define _T1GPOL                 0x40
#define _TMR1GE                 0x80

//==============================================================================


//==============================================================================
//        TRISA Bits

extern __at(0x008C) __sfr TRISA;

typedef struct
  {
  unsigned TRISA0               : 1;
  unsigned TRISA1               : 1;
  unsigned TRISA2               : 1;
  unsigned TRISA3               : 1;
  unsigned TRISA4               : 1;
  unsigned TRISA5               : 1;
  unsigned TRISA6               : 1;
  unsigned TRISA7               : 1;
  } __TRISAbits_t;

extern __at(0x008C) volatile __TRISAbits_t TRISAbits;

#define _TRISA0                 0x01
#define _TRISA1                 0x02
#define _TRISA2                 0x04
#define _TRISA3                 0x08
#define _TRISA4                 0x10
#define _TRISA5                 0x20
#define _TRISA6                 0x40
#define _TRISA7                 0x80

//==============================================================================


//==============================================================================
//        TRISB Bits

extern __at(0x008D) __sfr TRISB;

typedef struct
  {
  unsigned TRISB0               : 1;
  unsigned TRISB1               : 1;
  unsigned TRISB2               : 1;
  unsigned TRISB3               : 1;
  unsigned TRISB4               : 1;
  unsigned TRISB5               : 1;
  unsigned TRISB6               : 1;
  unsigned TRISB7               : 1;
  } __TRISBbits_t;

extern __at(0x008D) volatile __TRISBbits_t TRISBbits;

#define _TRISB0                 0x01
#define _TRISB1                 0x02
#define _TRISB2                 0x04
#define _TRISB3                 0x08
#define _TRISB4                 0x10
#define _TRISB5                 0x20
#define _TRISB6                 0x40
#define _TRISB7                 0x80

//==============================================================================


//==============================================================================
//        TRISC Bits

extern __at(0x008E) __sfr TRISC;

typedef struct
  {
  unsigned TRISC0               : 1;
  unsigned TRISC1               : 1;
  unsigned TRISC2               : 1;
  unsigned TRISC3               : 1;
  unsigned TRISC4               : 1;
  unsigned TRISC5               : 1;
  unsigned TRISC6               : 1;
  unsigned TRISC7               : 1;
  } __TRISCbits_t;

extern __at(0x008E) volatile __TRISCbits_t TRISCbits;

#define _TRISC0                 0x01
#define _TRISC1                 0x02
#define _TRISC2                 0x04
#define _TRISC3                 0x08
#define _TRISC4                 0x10
#define _TRISC5                 0x20
#define _TRISC6                 0x40
#define _TRISC7                 0x80

//==============================================================================

extern __at(0x0090) __sfr TRISE;

//==============================================================================
//        PIE1 Bits

extern __at(0x0091) __sfr PIE1;

typedef struct
  {
  unsigned TMR1IE               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned TXIE                 : 1;
  unsigned RCIE                 : 1;
  unsigned ADIE                 : 1;
  unsigned TMR1GIE              : 1;
  } __PIE1bits_t;

extern __at(0x0091) volatile __PIE1bits_t PIE1bits;

#define _TMR1IE                 0x01
#define _TXIE                   0x10
#define _RCIE                   0x20
#define _ADIE                   0x40
#define _TMR1GIE                0x80

//==============================================================================


//==============================================================================
//        PIE2 Bits

extern __at(0x0092) __sfr PIE2;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned LCDIE                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __PIE2bits_t;

extern __at(0x0092) volatile __PIE2bits_t PIE2bits;

#define _LCDIE                  0x04

//==============================================================================


//==============================================================================
//        OPTION_REG Bits

extern __at(0x0095) __sfr OPTION_REG;

typedef union
  {
  struct
    {
    unsigned PS0                : 1;
    unsigned PS1                : 1;
    unsigned PS2                : 1;
    unsigned PSA                : 1;
    unsigned TMR0SE             : 1;
    unsigned TMR0CS             : 1;
    unsigned INTEDG             : 1;
    unsigned NOT_WPUEN          : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned T0SE               : 1;
    unsigned T0CS               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned PS                 : 3;
    unsigned                    : 5;
    };
  } __OPTION_REGbits_t;

extern __at(0x0095) volatile __OPTION_REGbits_t OPTION_REGbits;

#define _PS0                    0x01
#define _PS1                    0x02
#define _PS2                    0x04
#define _PSA                    0x08
#define _TMR0SE                 0x10
#define _T0SE                   0x10
#define _TMR0CS                 0x20
#define _T0CS                   0x20
#define _INTEDG                 0x40
#define _NOT_WPUEN              0x80

//==============================================================================


//==============================================================================
//        PCON Bits

extern __at(0x0096) __sfr PCON;

typedef struct
  {
  unsigned NOT_BOR              : 1;
  unsigned NOT_POR              : 1;
  unsigned NOT_RI               : 1;
  unsigned NOT_RMCLR            : 1;
  unsigned NOT_RWDT             : 1;
  unsigned                      : 1;
  unsigned STKUNF               : 1;
  unsigned STKOVF               : 1;
  } __PCONbits_t;

extern __at(0x0096) volatile __PCONbits_t PCONbits;

#define _NOT_BOR                0x01
#define _NOT_POR                0x02
#define _NOT_RI                 0x04
#define _NOT_RMCLR              0x08
#define _NOT_RWDT               0x10
#define _STKUNF                 0x40
#define _STKOVF                 0x80

//==============================================================================


//==============================================================================
//        WDTCON Bits

extern __at(0x0097) __sfr WDTCON;

typedef union
  {
  struct
    {
    unsigned SWDTEN             : 1;
    unsigned WDTPS0             : 1;
    unsigned WDTPS1             : 1;
    unsigned WDTPS2             : 1;
    unsigned WDTPS3             : 1;
    unsigned WDTPS4             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned WDTPS              : 5;
    unsigned                    : 2;
    };
  } __WDTCONbits_t;

extern __at(0x0097) volatile __WDTCONbits_t WDTCONbits;

#define _SWDTEN                 0x01
#define _WDTPS0                 0x02
#define _WDTPS1                 0x04
#define _WDTPS2                 0x08
#define _WDTPS3                 0x10
#define _WDTPS4                 0x20

//==============================================================================


//==============================================================================
//        OSCCON Bits

extern __at(0x0099) __sfr OSCCON;

typedef union
  {
  struct
    {
    unsigned SCS0               : 1;
    unsigned SCS1               : 1;
    unsigned                    : 1;
    unsigned IRCF0              : 1;
    unsigned IRCF1              : 1;
    unsigned IRCF2              : 1;
    unsigned IRCF3              : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned SCS                : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 3;
    unsigned IRCF               : 4;
    unsigned                    : 1;
    };
  } __OSCCONbits_t;

extern __at(0x0099) volatile __OSCCONbits_t OSCCONbits;

#define _SCS0                   0x01
#define _SCS1                   0x02
#define _IRCF0                  0x08
#define _IRCF1                  0x10
#define _IRCF2                  0x20
#define _IRCF3                  0x40

//==============================================================================


//==============================================================================
//        OSCSTAT Bits

extern __at(0x009A) __sfr OSCSTAT;

typedef struct
  {
  unsigned HFIOFS               : 1;
  unsigned LFIOFR               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned HFIOFR               : 1;
  unsigned OSTS                 : 1;
  unsigned                      : 1;
  unsigned T1OSCR               : 1;
  } __OSCSTATbits_t;

extern __at(0x009A) volatile __OSCSTATbits_t OSCSTATbits;

#define _HFIOFS                 0x01
#define _LFIOFR                 0x02
#define _HFIOFR                 0x10
#define _OSTS                   0x20
#define _T1OSCR                 0x80

//==============================================================================

extern __at(0x009B) __sfr ADRES;
extern __at(0x009B) __sfr ADRESL;
extern __at(0x009C) __sfr ADRESH;

//==============================================================================
//        ADCON0 Bits

extern __at(0x009D) __sfr ADCON0;

typedef union
  {
  struct
    {
    unsigned ADON               : 1;
    unsigned GO_NOT_DONE        : 1;
    unsigned CHS0               : 1;
    unsigned CHS1               : 1;
    unsigned CHS2               : 1;
    unsigned CHS3               : 1;
    unsigned CHS4               : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned ADGO               : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned GO                 : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 1;
    unsigned NOT_DONE           : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CHS                : 5;
    unsigned                    : 1;
    };
  } __ADCON0bits_t;

extern __at(0x009D) volatile __ADCON0bits_t ADCON0bits;

#define _ADON                   0x01
#define _GO_NOT_DONE            0x02
#define _ADGO                   0x02
#define _GO                     0x02
#define _NOT_DONE               0x02
#define _CHS0                   0x04
#define _CHS1                   0x08
#define _CHS2                   0x10
#define _CHS3                   0x20
#define _CHS4                   0x40

//==============================================================================


//==============================================================================
//        ADCON1 Bits

extern __at(0x009E) __sfr ADCON1;

typedef union
  {
  struct
    {
    unsigned ADPREF0            : 1;
    unsigned ADPREF1            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned ADCS0              : 1;
    unsigned ADCS1              : 1;
    unsigned ADCS2              : 1;
    unsigned ADFM               : 1;
    };

  struct
    {
    unsigned ADPREF             : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 4;
    unsigned ADCS               : 3;
    unsigned                    : 1;
    };
  } __ADCON1bits_t;

extern __at(0x009E) volatile __ADCON1bits_t ADCON1bits;

#define _ADPREF0                0x01
#define _ADPREF1                0x02
#define _ADCS0                  0x10
#define _ADCS1                  0x20
#define _ADCS2                  0x40
#define _ADFM                   0x80

//==============================================================================


//==============================================================================
//        LATA Bits

extern __at(0x010C) __sfr LATA;

typedef struct
  {
  unsigned LATA0                : 1;
  unsigned LATA1                : 1;
  unsigned LATA2                : 1;
  unsigned LATA3                : 1;
  unsigned LATA4                : 1;
  unsigned LATA5                : 1;
  unsigned LATA6                : 1;
  unsigned LATA7                : 1;
  } __LATAbits_t;

extern __at(0x010C) volatile __LATAbits_t LATAbits;

#define _LATA0                  0x01
#define _LATA1                  0x02
#define _LATA2                  0x04
#define _LATA3                  0x08
#define _LATA4                  0x10
#define _LATA5                  0x20
#define _LATA6                  0x40
#define _LATA7                  0x80

//==============================================================================


//==============================================================================
//        LATB Bits

extern __at(0x010D) __sfr LATB;

typedef struct
  {
  unsigned LATB0                : 1;
  unsigned LATB1                : 1;
  unsigned LATB2                : 1;
  unsigned LATB3                : 1;
  unsigned LATB4                : 1;
  unsigned LATB5                : 1;
  unsigned LATB6                : 1;
  unsigned LATB7                : 1;
  } __LATBbits_t;

extern __at(0x010D) volatile __LATBbits_t LATBbits;

#define _LATB0                  0x01
#define _LATB1                  0x02
#define _LATB2                  0x04
#define _LATB3                  0x08
#define _LATB4                  0x10
#define _LATB5                  0x20
#define _LATB6                  0x40
#define _LATB7                  0x80

//==============================================================================


//==============================================================================
//        LATC Bits

extern __at(0x010E) __sfr LATC;

typedef struct
  {
  unsigned LATC0                : 1;
  unsigned LATC1                : 1;
  unsigned LATC2                : 1;
  unsigned LATC3                : 1;
  unsigned LATC4                : 1;
  unsigned LATC5                : 1;
  unsigned LATC6                : 1;
  unsigned LATC7                : 1;
  } __LATCbits_t;

extern __at(0x010E) volatile __LATCbits_t LATCbits;

#define _LATC0                  0x01
#define _LATC1                  0x02
#define _LATC2                  0x04
#define _LATC3                  0x08
#define _LATC4                  0x10
#define _LATC5                  0x20
#define _LATC6                  0x40
#define _LATC7                  0x80

//==============================================================================


//==============================================================================
//        BORCON Bits

extern __at(0x0116) __sfr BORCON;

typedef struct
  {
  unsigned BORRDY               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned BORFS                : 1;
  unsigned SBOREN               : 1;
  } __BORCONbits_t;

extern __at(0x0116) volatile __BORCONbits_t BORCONbits;

#define _BORRDY                 0x01
#define _BORFS                  0x40
#define _SBOREN                 0x80

//==============================================================================


//==============================================================================
//        FVRCON Bits

extern __at(0x0117) __sfr FVRCON;

typedef union
  {
  struct
    {
    unsigned ADFVR0             : 1;
    unsigned ADFVR1             : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned TSRNG              : 1;
    unsigned TSEN               : 1;
    unsigned FVRRDY             : 1;
    unsigned FVREN              : 1;
    };

  struct
    {
    unsigned ADFVR              : 2;
    unsigned                    : 6;
    };
  } __FVRCONbits_t;

extern __at(0x0117) volatile __FVRCONbits_t FVRCONbits;

#define _ADFVR0                 0x01
#define _ADFVR1                 0x02
#define _TSRNG                  0x10
#define _TSEN                   0x20
#define _FVRRDY                 0x40
#define _FVREN                  0x80

//==============================================================================


//==============================================================================
//        ANSELA Bits

extern __at(0x018C) __sfr ANSELA;

typedef struct
  {
  unsigned ANSA0                : 1;
  unsigned ANSA1                : 1;
  unsigned ANSA2                : 1;
  unsigned ANSA3                : 1;
  unsigned                      : 1;
  unsigned ANSA5                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __ANSELAbits_t;

extern __at(0x018C) volatile __ANSELAbits_t ANSELAbits;

#define _ANSA0                  0x01
#define _ANSA1                  0x02
#define _ANSA2                  0x04
#define _ANSA3                  0x08
#define _ANSA5                  0x20

//==============================================================================


//==============================================================================
//        ANSELB Bits

extern __at(0x018D) __sfr ANSELB;

typedef union
  {
  struct
    {
    unsigned ANSB0              : 1;
    unsigned ANSB1              : 1;
    unsigned ANSB2              : 1;
    unsigned ANSB3              : 1;
    unsigned ANSB4              : 1;
    unsigned ANSB5              : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned ANSB               : 6;
    unsigned                    : 2;
    };
  } __ANSELBbits_t;

extern __at(0x018D) volatile __ANSELBbits_t ANSELBbits;

#define _ANSB0                  0x01
#define _ANSB1                  0x02
#define _ANSB2                  0x04
#define _ANSB3                  0x08
#define _ANSB4                  0x10
#define _ANSB5                  0x20

//==============================================================================

extern __at(0x0191) __sfr PMADR;
extern __at(0x0191) __sfr PMADRL;
extern __at(0x0192) __sfr PMADRH;
extern __at(0x0193) __sfr PMDAT;
extern __at(0x0193) __sfr PMDATL;
extern __at(0x0194) __sfr PMDATH;

//==============================================================================
//        PMCON1 Bits

extern __at(0x0195) __sfr PMCON1;

typedef struct
  {
  unsigned RD                   : 1;
  unsigned WR                   : 1;
  unsigned WREN                 : 1;
  unsigned WRERR                : 1;
  unsigned FREE                 : 1;
  unsigned LWLO                 : 1;
  unsigned CFGS                 : 1;
  unsigned                      : 1;
  } __PMCON1bits_t;

extern __at(0x0195) volatile __PMCON1bits_t PMCON1bits;

#define _RD                     0x01
#define _WR                     0x02
#define _WREN                   0x04
#define _WRERR                  0x08
#define _FREE                   0x10
#define _LWLO                   0x20
#define _CFGS                   0x40

//==============================================================================

extern __at(0x0196) __sfr PMCON2;
extern __at(0x0199) __sfr RC1REG;
extern __at(0x0199) __sfr RCREG;
extern __at(0x0199) __sfr RCREG1;
extern __at(0x019A) __sfr TX1REG;
extern __at(0x019A) __sfr TXREG;
extern __at(0x019A) __sfr TXREG1;

//==============================================================================
//        SP1BRGL Bits

extern __at(0x019B) __sfr SP1BRGL;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SP1BRGLbits_t;

extern __at(0x019B) volatile __SP1BRGLbits_t SP1BRGLbits;

#define _BRG0                   0x01
#define _BRG1                   0x02
#define _BRG2                   0x04
#define _BRG3                   0x08
#define _BRG4                   0x10
#define _BRG5                   0x20
#define _BRG6                   0x40
#define _BRG7                   0x80

//==============================================================================


//==============================================================================
//        SPBRG Bits

extern __at(0x019B) __sfr SPBRG;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SPBRGbits_t;

extern __at(0x019B) volatile __SPBRGbits_t SPBRGbits;

#define _SPBRG_BRG0             0x01
#define _SPBRG_BRG1             0x02
#define _SPBRG_BRG2             0x04
#define _SPBRG_BRG3             0x08
#define _SPBRG_BRG4             0x10
#define _SPBRG_BRG5             0x20
#define _SPBRG_BRG6             0x40
#define _SPBRG_BRG7             0x80

//==============================================================================


//==============================================================================
//        SPBRGL Bits

extern __at(0x019B) __sfr SPBRGL;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SPBRGLbits_t;

extern __at(0x019B) volatile __SPBRGLbits_t SPBRGLbits;

#define _SPBRGL_BRG0            0x01
#define _SPBRGL_BRG1            0x02
#define _SPBRGL_BRG2            0x04
#define _SPBRGL_BRG3            0x08
#define _SPBRGL_BRG4            0x10
#define _SPBRGL_BRG5            0x20
#define _SPBRGL_BRG6            0x40
#define _SPBRGL_BRG7            0x80

//==============================================================================


//==============================================================================
//        SPBRGL1 Bits

extern __at(0x019B) __sfr SPBRGL1;

typedef struct
  {
  unsigned BRG0                 : 1;
  unsigned BRG1                 : 1;
  unsigned BRG2                 : 1;
  unsigned BRG3                 : 1;
  unsigned BRG4                 : 1;
  unsigned BRG5                 : 1;
  unsigned BRG6                 : 1;
  unsigned BRG7                 : 1;
  } __SPBRGL1bits_t;

extern __at(0x019B) volatile __SPBRGL1bits_t SPBRGL1bits;

#define _SPBRGL1_BRG0           0x01
#define _SPBRGL1_BRG1           0x02
#define _SPBRGL1_BRG2           0x04
#define _SPBRGL1_BRG3           0x08
#define _SPBRGL1_BRG4           0x10
#define _SPBRGL1_BRG5           0x20
#define _SPBRGL1_BRG6           0x40
#define _SPBRGL1_BRG7           0x80

//==============================================================================


//==============================================================================
//        SP1BRGH Bits

extern __at(0x019C) __sfr SP1BRGH;

typedef struct
  {
  unsigned BRG8                 : 1;
  unsigned BRG9                 : 1;
  unsigned BRG10                : 1;
  unsigned BRG11                : 1;
  unsigned BRG12                : 1;
  unsigned BRG13                : 1;
  unsigned BRG14                : 1;
  unsigned BRG15                : 1;
  } __SP1BRGHbits_t;

extern __at(0x019C) volatile __SP1BRGHbits_t SP1BRGHbits;

#define _BRG8                   0x01
#define _BRG9                   0x02
#define _BRG10                  0x04
#define _BRG11                  0x08
#define _BRG12                  0x10
#define _BRG13                  0x20
#define _BRG14                  0x40
#define _BRG15                  0x80

//==============================================================================


//==============================================================================
//        SPBRGH Bits

extern __at(0x019C) __sfr SPBRGH;

typedef struct
  {
  unsigned BRG8                 : 1;
  unsigned BRG9                 : 1;
  unsigned BRG10                : 1;
  unsigned BRG11                : 1;
  unsigned BRG12                : 1;
  unsigned BRG13                : 1;
  unsigned BRG14                : 1;
  unsigned BRG15                : 1;
  } __SPBRGHbits_t;

extern __at(0x019C) volatile __SPBRGHbits_t SPBRGHbits;

#define _SPBRGH_BRG8            0x01
#define _SPBRGH_BRG9            0x02
#define _SPBRGH_BRG10           0x04
#define _SPBRGH_BRG11           0x08
#define _SPBRGH_BRG12           0x10
#define _SPBRGH_BRG13           0x20
#define _SPBRGH_BRG14           0x40
#define _SPBRGH_BRG15           0x80

//==============================================================================


//==============================================================================
//        SPBRGH1 Bits

extern __at(0x019C) __sfr SPBRGH1;

typedef struct
  {
  unsigned BRG8                 : 1;
  unsigned BRG9                 : 1;
  unsigned BRG10                : 1;
  unsigned BRG11                : 1;
  unsigned BRG12                : 1;
  unsigned BRG13                : 1;
  unsigned BRG14                : 1;
  unsigned BRG15                : 1;
  } __SPBRGH1bits_t;

extern __at(0x019C) volatile __SPBRGH1bits_t SPBRGH1bits;

#define _SPBRGH1_BRG8           0x01
#define _SPBRGH1_BRG9           0x02
#define _SPBRGH1_BRG10          0x04
#define _SPBRGH1_BRG11          0x08
#define _SPBRGH1_BRG12          0x10
#define _SPBRGH1_BRG13          0x20
#define _SPBRGH1_BRG14          0x40
#define _SPBRGH1_BRG15          0x80

//==============================================================================


//==============================================================================
//        RC1STA Bits

extern __at(0x019D) __sfr RC1STA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RC1STAbits_t;

extern __at(0x019D) volatile __RC1STAbits_t RC1STAbits;

#define _RX9D                   0x01
#define _OERR                   0x02
#define _FERR                   0x04
#define _ADDEN                  0x08
#define _CREN                   0x10
#define _SREN                   0x20
#define _RX9                    0x40
#define _SPEN                   0x80

//==============================================================================


//==============================================================================
//        RCSTA Bits

extern __at(0x019D) __sfr RCSTA;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTAbits_t;

extern __at(0x019D) volatile __RCSTAbits_t RCSTAbits;

#define _RCSTA_RX9D             0x01
#define _RCSTA_OERR             0x02
#define _RCSTA_FERR             0x04
#define _RCSTA_ADDEN            0x08
#define _RCSTA_CREN             0x10
#define _RCSTA_SREN             0x20
#define _RCSTA_RX9              0x40
#define _RCSTA_SPEN             0x80

//==============================================================================


//==============================================================================
//        RCSTA1 Bits

extern __at(0x019D) __sfr RCSTA1;

typedef struct
  {
  unsigned RX9D                 : 1;
  unsigned OERR                 : 1;
  unsigned FERR                 : 1;
  unsigned ADDEN                : 1;
  unsigned CREN                 : 1;
  unsigned SREN                 : 1;
  unsigned RX9                  : 1;
  unsigned SPEN                 : 1;
  } __RCSTA1bits_t;

extern __at(0x019D) volatile __RCSTA1bits_t RCSTA1bits;

#define _RCSTA1_RX9D            0x01
#define _RCSTA1_OERR            0x02
#define _RCSTA1_FERR            0x04
#define _RCSTA1_ADDEN           0x08
#define _RCSTA1_CREN            0x10
#define _RCSTA1_SREN            0x20
#define _RCSTA1_RX9             0x40
#define _RCSTA1_SPEN            0x80

//==============================================================================


//==============================================================================
//        TX1STA Bits

extern __at(0x019E) __sfr TX1STA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TX1STAbits_t;

extern __at(0x019E) volatile __TX1STAbits_t TX1STAbits;

#define _TX9D                   0x01
#define _TRMT                   0x02
#define _BRGH                   0x04
#define _SENDB                  0x08
#define _SYNC                   0x10
#define _TXEN                   0x20
#define _TX9                    0x40
#define _CSRC                   0x80

//==============================================================================


//==============================================================================
//        TXSTA Bits

extern __at(0x019E) __sfr TXSTA;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTAbits_t;

extern __at(0x019E) volatile __TXSTAbits_t TXSTAbits;

#define _TXSTA_TX9D             0x01
#define _TXSTA_TRMT             0x02
#define _TXSTA_BRGH             0x04
#define _TXSTA_SENDB            0x08
#define _TXSTA_SYNC             0x10
#define _TXSTA_TXEN             0x20
#define _TXSTA_TX9              0x40
#define _TXSTA_CSRC             0x80

//==============================================================================


//==============================================================================
//        TXSTA1 Bits

extern __at(0x019E) __sfr TXSTA1;

typedef struct
  {
  unsigned TX9D                 : 1;
  unsigned TRMT                 : 1;
  unsigned BRGH                 : 1;
  unsigned SENDB                : 1;
  unsigned SYNC                 : 1;
  unsigned TXEN                 : 1;
  unsigned TX9                  : 1;
  unsigned CSRC                 : 1;
  } __TXSTA1bits_t;

extern __at(0x019E) volatile __TXSTA1bits_t TXSTA1bits;

#define _TXSTA1_TX9D            0x01
#define _TXSTA1_TRMT            0x02
#define _TXSTA1_BRGH            0x04
#define _TXSTA1_SENDB           0x08
#define _TXSTA1_SYNC            0x10
#define _TXSTA1_TXEN            0x20
#define _TXSTA1_TX9             0x40
#define _TXSTA1_CSRC            0x80

//==============================================================================


//==============================================================================
//        BAUD1CON Bits

extern __at(0x019F) __sfr BAUD1CON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUD1CONbits_t;

extern __at(0x019F) volatile __BAUD1CONbits_t BAUD1CONbits;

#define _ABDEN                  0x01
#define _WUE                    0x02
#define _BRG16                  0x08
#define _SCKP                   0x10
#define _RCIDL                  0x40
#define _ABDOVF                 0x80

//==============================================================================


//==============================================================================
//        BAUDCON Bits

extern __at(0x019F) __sfr BAUDCON;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCONbits_t;

extern __at(0x019F) volatile __BAUDCONbits_t BAUDCONbits;

#define _BAUDCON_ABDEN          0x01
#define _BAUDCON_WUE            0x02
#define _BAUDCON_BRG16          0x08
#define _BAUDCON_SCKP           0x10
#define _BAUDCON_RCIDL          0x40
#define _BAUDCON_ABDOVF         0x80

//==============================================================================


//==============================================================================
//        BAUDCON1 Bits

extern __at(0x019F) __sfr BAUDCON1;

typedef struct
  {
  unsigned ABDEN                : 1;
  unsigned WUE                  : 1;
  unsigned                      : 1;
  unsigned BRG16                : 1;
  unsigned SCKP                 : 1;
  unsigned                      : 1;
  unsigned RCIDL                : 1;
  unsigned ABDOVF               : 1;
  } __BAUDCON1bits_t;

extern __at(0x019F) volatile __BAUDCON1bits_t BAUDCON1bits;

#define _BAUDCON1_ABDEN         0x01
#define _BAUDCON1_WUE           0x02
#define _BAUDCON1_BRG16         0x08
#define _BAUDCON1_SCKP          0x10
#define _BAUDCON1_RCIDL         0x40
#define _BAUDCON1_ABDOVF        0x80

//==============================================================================


//==============================================================================
//        WPUB Bits

extern __at(0x020D) __sfr WPUB;

typedef struct
  {
  unsigned WPUB0                : 1;
  unsigned WPUB1                : 1;
  unsigned WPUB2                : 1;
  unsigned WPUB3                : 1;
  unsigned WPUB4                : 1;
  unsigned WPUB5                : 1;
  unsigned WPUB6                : 1;
  unsigned WPUB7                : 1;
  } __WPUBbits_t;

extern __at(0x020D) volatile __WPUBbits_t WPUBbits;

#define _WPUB0                  0x01
#define _WPUB1                  0x02
#define _WPUB2                  0x04
#define _WPUB3                  0x08
#define _WPUB4                  0x10
#define _WPUB5                  0x20
#define _WPUB6                  0x40
#define _WPUB7                  0x80

//==============================================================================


//==============================================================================
//        WPUE Bits

extern __at(0x0210) __sfr WPUE;

typedef struct
  {
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned WPUE3                : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __WPUEbits_t;

extern __at(0x0210) volatile __WPUEbits_t WPUEbits;

#define _WPUE3                  0x08

//==============================================================================


//==============================================================================
//        IOCBP Bits

extern __at(0x0394) __sfr IOCBP;

typedef struct
  {
  unsigned IOCBP0               : 1;
  unsigned IOCBP1               : 1;
  unsigned IOCBP2               : 1;
  unsigned IOCBP3               : 1;
  unsigned IOCBP4               : 1;
  unsigned IOCBP5               : 1;
  unsigned IOCBP6               : 1;
  unsigned IOCBP7               : 1;
  } __IOCBPbits_t;

extern __at(0x0394) volatile __IOCBPbits_t IOCBPbits;

#define _IOCBP0                 0x01
#define _IOCBP1                 0x02
#define _IOCBP2                 0x04
#define _IOCBP3                 0x08
#define _IOCBP4                 0x10
#define _IOCBP5                 0x20
#define _IOCBP6                 0x40
#define _IOCBP7                 0x80

//==============================================================================


//==============================================================================
//        IOCBN Bits

extern __at(0x0395) __sfr IOCBN;

typedef struct
  {
  unsigned IOCBN0               : 1;
  unsigned IOCBN1               : 1;
  unsigned IOCBN2               : 1;
  unsigned IOCBN3               : 1;
  unsigned IOCBN4               : 1;
  unsigned IOCBN5               : 1;
  unsigned IOCBN6               : 1;
  unsigned IOCBN7               : 1;
  } __IOCBNbits_t;

extern __at(0x0395) volatile __IOCBNbits_t IOCBNbits;

#define _IOCBN0                 0x01
#define _IOCBN1                 0x02
#define _IOCBN2                 0x04
#define _IOCBN3                 0x08
#define _IOCBN4                 0x10
#define _IOCBN5                 0x20
#define _IOCBN6                 0x40
#define _IOCBN7                 0x80

//==============================================================================


//==============================================================================
//        IOCBF Bits

extern __at(0x0396) __sfr IOCBF;

typedef struct
  {
  unsigned IOCBF0               : 1;
  unsigned IOCBF1               : 1;
  unsigned IOCBF2               : 1;
  unsigned IOCBF3               : 1;
  unsigned IOCBF4               : 1;
  unsigned IOCBF5               : 1;
  unsigned IOCBF6               : 1;
  unsigned IOCBF7               : 1;
  } __IOCBFbits_t;

extern __at(0x0396) volatile __IOCBFbits_t IOCBFbits;

#define _IOCBF0                 0x01
#define _IOCBF1                 0x02
#define _IOCBF2                 0x04
#define _IOCBF3                 0x08
#define _IOCBF4                 0x10
#define _IOCBF5                 0x20
#define _IOCBF6                 0x40
#define _IOCBF7                 0x80

//==============================================================================


//==============================================================================
//        LCDCON Bits

extern __at(0x0791) __sfr LCDCON;

typedef union
  {
  struct
    {
    unsigned LMUX0              : 1;
    unsigned LMUX1              : 1;
    unsigned CS0                : 1;
    unsigned CS1                : 1;
    unsigned                    : 1;
    unsigned WERR               : 1;
    unsigned SLPEN              : 1;
    unsigned LCDEN              : 1;
    };

  struct
    {
    unsigned LMUX               : 2;
    unsigned                    : 6;
    };

  struct
    {
    unsigned                    : 2;
    unsigned CS                 : 2;
    unsigned                    : 4;
    };
  } __LCDCONbits_t;

extern __at(0x0791) volatile __LCDCONbits_t LCDCONbits;

#define _LMUX0                  0x01
#define _LMUX1                  0x02
#define _CS0                    0x04
#define _CS1                    0x08
#define _WERR                   0x20
#define _SLPEN                  0x40
#define _LCDEN                  0x80

//==============================================================================


//==============================================================================
//        LCDPS Bits

extern __at(0x0792) __sfr LCDPS;

typedef union
  {
  struct
    {
    unsigned LP0                : 1;
    unsigned LP1                : 1;
    unsigned LP2                : 1;
    unsigned LP3                : 1;
    unsigned WA                 : 1;
    unsigned LCDA               : 1;
    unsigned BIASMD             : 1;
    unsigned WFT                : 1;
    };

  struct
    {
    unsigned LP                 : 4;
    unsigned                    : 4;
    };
  } __LCDPSbits_t;

extern __at(0x0792) volatile __LCDPSbits_t LCDPSbits;

#define _LP0                    0x01
#define _LP1                    0x02
#define _LP2                    0x04
#define _LP3                    0x08
#define _WA                     0x10
#define _LCDA                   0x20
#define _BIASMD                 0x40
#define _WFT                    0x80

//==============================================================================


//==============================================================================
//        LCDREF Bits

extern __at(0x0793) __sfr LCDREF;

typedef struct
  {
  unsigned                      : 1;
  unsigned VLCD1PE              : 1;
  unsigned VLCD2PE              : 1;
  unsigned VLCD3PE              : 1;
  unsigned                      : 1;
  unsigned LCDIRI               : 1;
  unsigned                      : 1;
  unsigned LCDIRE               : 1;
  } __LCDREFbits_t;

extern __at(0x0793) volatile __LCDREFbits_t LCDREFbits;

#define _VLCD1PE                0x02
#define _VLCD2PE                0x04
#define _VLCD3PE                0x08
#define _LCDIRI                 0x20
#define _LCDIRE                 0x80

//==============================================================================


//==============================================================================
//        LCDCST Bits

extern __at(0x0794) __sfr LCDCST;

typedef union
  {
  struct
    {
    unsigned LCDCST0            : 1;
    unsigned LCDCST1            : 1;
    unsigned LCDCST2            : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    unsigned                    : 1;
    };

  struct
    {
    unsigned LCDCST             : 3;
    unsigned                    : 5;
    };
  } __LCDCSTbits_t;

extern __at(0x0794) volatile __LCDCSTbits_t LCDCSTbits;

#define _LCDCST0                0x01
#define _LCDCST1                0x02
#define _LCDCST2                0x04

//==============================================================================


//==============================================================================
//        LCDRL Bits

extern __at(0x0795) __sfr LCDRL;

typedef union
  {
  struct
    {
    unsigned LRLAT0             : 1;
    unsigned LRLAT1             : 1;
    unsigned LRLAT2             : 1;
    unsigned                    : 1;
    unsigned LRLBP0             : 1;
    unsigned LRLBP1             : 1;
    unsigned LRLAP0             : 1;
    unsigned LRLAP1             : 1;
    };

  struct
    {
    unsigned LRLAT              : 3;
    unsigned                    : 5;
    };

  struct
    {
    unsigned                    : 4;
    unsigned LRLBP              : 2;
    unsigned                    : 2;
    };

  struct
    {
    unsigned                    : 6;
    unsigned LRLAP              : 2;
    };
  } __LCDRLbits_t;

extern __at(0x0795) volatile __LCDRLbits_t LCDRLbits;

#define _LRLAT0                 0x01
#define _LRLAT1                 0x02
#define _LRLAT2                 0x04
#define _LRLBP0                 0x10
#define _LRLBP1                 0x20
#define _LRLAP0                 0x40
#define _LRLAP1                 0x80

//==============================================================================


//==============================================================================
//        LCDSE0 Bits

extern __at(0x0798) __sfr LCDSE0;

typedef struct
  {
  unsigned SE0                  : 1;
  unsigned SE1                  : 1;
  unsigned SE2                  : 1;
  unsigned SE3                  : 1;
  unsigned SE4                  : 1;
  unsigned SE5                  : 1;
  unsigned SE6                  : 1;
  unsigned SE7                  : 1;
  } __LCDSE0bits_t;

extern __at(0x0798) volatile __LCDSE0bits_t LCDSE0bits;

#define _SE0                    0x01
#define _SE1                    0x02
#define _SE2                    0x04
#define _SE3                    0x08
#define _SE4                    0x10
#define _SE5                    0x20
#define _SE6                    0x40
#define _SE7                    0x80

//==============================================================================


//==============================================================================
//        LCDSE1 Bits

extern __at(0x0799) __sfr LCDSE1;

typedef struct
  {
  unsigned SE8                  : 1;
  unsigned SE9                  : 1;
  unsigned SE10                 : 1;
  unsigned SE11                 : 1;
  unsigned SE12                 : 1;
  unsigned SE13                 : 1;
  unsigned SE14                 : 1;
  unsigned SE15                 : 1;
  } __LCDSE1bits_t;

extern __at(0x0799) volatile __LCDSE1bits_t LCDSE1bits;

#define _SE8                    0x01
#define _SE9                    0x02
#define _SE10                   0x04
#define _SE11                   0x08
#define _SE12                   0x10
#define _SE13                   0x20
#define _SE14                   0x40
#define _SE15                   0x80

//==============================================================================


//==============================================================================
//        LCDSE3 Bits

extern __at(0x079B) __sfr LCDSE3;

typedef struct
  {
  unsigned SE24                 : 1;
  unsigned SE25                 : 1;
  unsigned SE26                 : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDSE3bits_t;

extern __at(0x079B) volatile __LCDSE3bits_t LCDSE3bits;

#define _SE24                   0x01
#define _SE25                   0x02
#define _SE26                   0x04

//==============================================================================


//==============================================================================
//        LCDDATA0 Bits

extern __at(0x07A0) __sfr LCDDATA0;

typedef struct
  {
  unsigned SEG0COM0             : 1;
  unsigned SEG1COM0             : 1;
  unsigned SEG2COM0             : 1;
  unsigned SEG3COM0             : 1;
  unsigned SEG4COM0             : 1;
  unsigned SEG5COM0             : 1;
  unsigned SEG6COM0             : 1;
  unsigned SEG7COM0             : 1;
  } __LCDDATA0bits_t;

extern __at(0x07A0) volatile __LCDDATA0bits_t LCDDATA0bits;

#define _SEG0COM0               0x01
#define _SEG1COM0               0x02
#define _SEG2COM0               0x04
#define _SEG3COM0               0x08
#define _SEG4COM0               0x10
#define _SEG5COM0               0x20
#define _SEG6COM0               0x40
#define _SEG7COM0               0x80

//==============================================================================


//==============================================================================
//        LCDDATA1 Bits

extern __at(0x07A1) __sfr LCDDATA1;

typedef struct
  {
  unsigned SEG8COM0             : 1;
  unsigned SEG9COM0             : 1;
  unsigned SEG10COM0            : 1;
  unsigned SEG11COM0            : 1;
  unsigned SEG12COM0            : 1;
  unsigned SEG13COM0            : 1;
  unsigned SEG14COM0            : 1;
  unsigned SEG15COM0            : 1;
  } __LCDDATA1bits_t;

extern __at(0x07A1) volatile __LCDDATA1bits_t LCDDATA1bits;

#define _SEG8COM0               0x01
#define _SEG9COM0               0x02
#define _SEG10COM0              0x04
#define _SEG11COM0              0x08
#define _SEG12COM0              0x10
#define _SEG13COM0              0x20
#define _SEG14COM0              0x40
#define _SEG15COM0              0x80

//==============================================================================


//==============================================================================
//        LCDDATA3 Bits

extern __at(0x07A3) __sfr LCDDATA3;

typedef struct
  {
  unsigned SEG0COM1             : 1;
  unsigned SEG1COM1             : 1;
  unsigned SEG2COM1             : 1;
  unsigned SEG3COM1             : 1;
  unsigned SEG4COM1             : 1;
  unsigned SEG5COM1             : 1;
  unsigned SEG6COM1             : 1;
  unsigned SEG7COM1             : 1;
  } __LCDDATA3bits_t;

extern __at(0x07A3) volatile __LCDDATA3bits_t LCDDATA3bits;

#define _SEG0COM1               0x01
#define _SEG1COM1               0x02
#define _SEG2COM1               0x04
#define _SEG3COM1               0x08
#define _SEG4COM1               0x10
#define _SEG5COM1               0x20
#define _SEG6COM1               0x40
#define _SEG7COM1               0x80

//==============================================================================


//==============================================================================
//        LCDDATA4 Bits

extern __at(0x07A4) __sfr LCDDATA4;

typedef struct
  {
  unsigned SEG8COM1             : 1;
  unsigned SEG9COM1             : 1;
  unsigned SEG10COM1            : 1;
  unsigned SEG11COM1            : 1;
  unsigned SEG12COM1            : 1;
  unsigned SEG13COM1            : 1;
  unsigned SEG14COM1            : 1;
  unsigned SEG15COM1            : 1;
  } __LCDDATA4bits_t;

extern __at(0x07A4) volatile __LCDDATA4bits_t LCDDATA4bits;

#define _SEG8COM1               0x01
#define _SEG9COM1               0x02
#define _SEG10COM1              0x04
#define _SEG11COM1              0x08
#define _SEG12COM1              0x10
#define _SEG13COM1              0x20
#define _SEG14COM1              0x40
#define _SEG15COM1              0x80

//==============================================================================


//==============================================================================
//        LCDDATA6 Bits

extern __at(0x07A6) __sfr LCDDATA6;

typedef struct
  {
  unsigned SEG0COM2             : 1;
  unsigned SEG1COM2             : 1;
  unsigned SEG2COM2             : 1;
  unsigned SEG3COM2             : 1;
  unsigned SEG4COM2             : 1;
  unsigned SEG5COM2             : 1;
  unsigned SEG6COM2             : 1;
  unsigned SEG7COM2             : 1;
  } __LCDDATA6bits_t;

extern __at(0x07A6) volatile __LCDDATA6bits_t LCDDATA6bits;

#define _SEG0COM2               0x01
#define _SEG1COM2               0x02
#define _SEG2COM2               0x04
#define _SEG3COM2               0x08
#define _SEG4COM2               0x10
#define _SEG5COM2               0x20
#define _SEG6COM2               0x40
#define _SEG7COM2               0x80

//==============================================================================


//==============================================================================
//        LCDDATA7 Bits

extern __at(0x07A7) __sfr LCDDATA7;

typedef struct
  {
  unsigned SEG8COM2             : 1;
  unsigned SEG9COM2             : 1;
  unsigned SEG10COM2            : 1;
  unsigned SEG11COM2            : 1;
  unsigned SEG12COM2            : 1;
  unsigned SEG13COM2            : 1;
  unsigned SEG14COM2            : 1;
  unsigned SEG15COM2            : 1;
  } __LCDDATA7bits_t;

extern __at(0x07A7) volatile __LCDDATA7bits_t LCDDATA7bits;

#define _SEG8COM2               0x01
#define _SEG9COM2               0x02
#define _SEG10COM2              0x04
#define _SEG11COM2              0x08
#define _SEG12COM2              0x10
#define _SEG13COM2              0x20
#define _SEG14COM2              0x40
#define _SEG15COM2              0x80

//==============================================================================


//==============================================================================
//        LCDDATA9 Bits

extern __at(0x07A9) __sfr LCDDATA9;

typedef struct
  {
  unsigned SEG0COM3             : 1;
  unsigned SEG1COM3             : 1;
  unsigned SEG2COM3             : 1;
  unsigned SEG3COM3             : 1;
  unsigned SEG4COM3             : 1;
  unsigned SEG5COM3             : 1;
  unsigned SEG6COM3             : 1;
  unsigned SEG7COM3             : 1;
  } __LCDDATA9bits_t;

extern __at(0x07A9) volatile __LCDDATA9bits_t LCDDATA9bits;

#define _SEG0COM3               0x01
#define _SEG1COM3               0x02
#define _SEG2COM3               0x04
#define _SEG3COM3               0x08
#define _SEG4COM3               0x10
#define _SEG5COM3               0x20
#define _SEG6COM3               0x40
#define _SEG7COM3               0x80

//==============================================================================


//==============================================================================
//        LCDDATA10 Bits

extern __at(0x07AA) __sfr LCDDATA10;

typedef struct
  {
  unsigned SEG8COM3             : 1;
  unsigned SEG9COM3             : 1;
  unsigned SEG10COM3            : 1;
  unsigned SEG11COM3            : 1;
  unsigned SEG12COM3            : 1;
  unsigned SEG13COM3            : 1;
  unsigned SEG14COM3            : 1;
  unsigned SEG15COM3            : 1;
  } __LCDDATA10bits_t;

extern __at(0x07AA) volatile __LCDDATA10bits_t LCDDATA10bits;

#define _SEG8COM3               0x01
#define _SEG9COM3               0x02
#define _SEG10COM3              0x04
#define _SEG11COM3              0x08
#define _SEG12COM3              0x10
#define _SEG13COM3              0x20
#define _SEG14COM3              0x40
#define _SEG15COM3              0x80

//==============================================================================


//==============================================================================
//        LCDDATA12 Bits

extern __at(0x07AC) __sfr LCDDATA12;

typedef struct
  {
  unsigned SEG24COM0            : 1;
  unsigned SEG25COM0            : 1;
  unsigned SEG26COM0            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA12bits_t;

extern __at(0x07AC) volatile __LCDDATA12bits_t LCDDATA12bits;

#define _SEG24COM0              0x01
#define _SEG25COM0              0x02
#define _SEG26COM0              0x04

//==============================================================================


//==============================================================================
//        LCDDATA15 Bits

extern __at(0x07AF) __sfr LCDDATA15;

typedef struct
  {
  unsigned SEG24COM1            : 1;
  unsigned SEG25COM1            : 1;
  unsigned SEG26COM1            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA15bits_t;

extern __at(0x07AF) volatile __LCDDATA15bits_t LCDDATA15bits;

#define _SEG24COM1              0x01
#define _SEG25COM1              0x02
#define _SEG26COM1              0x04

//==============================================================================


//==============================================================================
//        LCDDATA18 Bits

extern __at(0x07B2) __sfr LCDDATA18;

typedef struct
  {
  unsigned SEG24COM2            : 1;
  unsigned SEG25COM2            : 1;
  unsigned SEG26COM2            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA18bits_t;

extern __at(0x07B2) volatile __LCDDATA18bits_t LCDDATA18bits;

#define _SEG24COM2              0x01
#define _SEG25COM2              0x02
#define _SEG26COM2              0x04

//==============================================================================


//==============================================================================
//        LCDDATA21 Bits

extern __at(0x07B5) __sfr LCDDATA21;

typedef struct
  {
  unsigned SEG24COM3            : 1;
  unsigned SEG25COM3            : 1;
  unsigned SEG26COM3            : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __LCDDATA21bits_t;

extern __at(0x07B5) volatile __LCDDATA21bits_t LCDDATA21bits;

#define _SEG24COM3              0x01
#define _SEG25COM3              0x02
#define _SEG26COM3              0x04

//==============================================================================


//==============================================================================
//        STATUS_SHAD Bits

extern __at(0x0FE4) __sfr STATUS_SHAD;

typedef struct
  {
  unsigned C_SHAD               : 1;
  unsigned DC_SHAD              : 1;
  unsigned Z_SHAD               : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  unsigned                      : 1;
  } __STATUS_SHADbits_t;

extern __at(0x0FE4) volatile __STATUS_SHADbits_t STATUS_SHADbits;

#define _C_SHAD                 0x01
#define _DC_SHAD                0x02
#define _Z_SHAD                 0x04

//==============================================================================

extern __at(0x0FE5) __sfr WREG_SHAD;
extern __at(0x0FE6) __sfr BSR_SHAD;
extern __at(0x0FE7) __sfr PCLATH_SHAD;
extern __at(0x0FE8) __sfr FSR0L_SHAD;
extern __at(0x0FE9) __sfr FSR0H_SHAD;
extern __at(0x0FEA) __sfr FSR1L_SHAD;
extern __at(0x0FEB) __sfr FSR1H_SHAD;
extern __at(0x0FED) __sfr STKPTR;
extern __at(0x0FEE) __sfr TOSL;
extern __at(0x0FEF) __sfr TOSH;

//==============================================================================
//
//        Configuration Bits
//
//==============================================================================

#define _CONFIG1                0x8007
#define _CONFIG2                0x8008

//----------------------------- CONFIG1 Options -------------------------------

#define _FOSC_INTOSC            0xFFFC  // INTOSC oscillator: I/O function on CLKIN pin.
#define _FOSC_ECL               0xFFFD  // ECL, External Clock, Low Power Mode (0-0.5 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECM               0xFFFE  // ECM, External Clock, Medium Power Mode (0.5-4 MHz): device clock supplied to CLKIN pin.
#define _FOSC_ECH               0xFFFF  // ECH, External Clock, High Power Mode (4-32 MHz): device clock supplied to CLKIN pin.
#define _WDTE_OFF               0xFFE7  // WDT disabled.
#define _WDTE_SWDTEN            0xFFEF  // WDT controlled by the SWDTEN bit in the WDTCON register.
#define _WDTE_NSLEEP            0xFFF7  // WDT enabled while running and disabled in Sleep.
#define _WDTE_ON                0xFFFF  // WDT enabled.
#define _PWRTE_ON               0xFFDF  // PWRT enabled.
#define _PWRTE_OFF              0xFFFF  // PWRT disabled.
#define _MCLRE_OFF              0xFFBF  // MCLR/VPP pin function is digital input.
#define _MCLRE_ON               0xFFFF  // MCLR/VPP pin function is MCLR.
#define _CP_ON                  0xFF7F  // Program memory code protection is enabled.
#define _CP_OFF                 0xFFFF  // Program memory code protection is disabled.
#define _BOREN_OFF              0xF9FF  // Brown-out Reset disabled.
#define _BOREN_SBODEN           0xFBFF  // Brown-out Reset controlled by the SBOREN bit in the BORCON register.
#define _BOREN_NSLEEP           0xFDFF  // Brown-out Reset enabled while running and disabled in Sleep.
#define _BOREN_ON               0xFFFF  // Brown-out Reset enabled.
#define _CLKOUTEN_ON            0xF7FF  // CLKOUT function is enabled on the CLKOUT pin.
#define _CLKOUTEN_OFF           0xFFFF  // CLKOUT function is disabled. I/O or oscillator function on the CLKOUT pin.

//----------------------------- CONFIG2 Options -------------------------------

#define _WRT_ALL                0xFFFC  // 000h to 7FFh write protected, no addresses may be modified by PMCON control.
#define _WRT_HALF               0xFFFD  // 000h to 3FFh write protected, 400h to 7FFh may be modified by PMCON control.
#define _WRT_BOOT               0xFFFE  // 000h to 1FFh write protected, 200h to 7FFh may be modified by PMCON control.
#define _WRT_OFF                0xFFFF  // Write protection off.
#define _STVREN_OFF             0xFDFF  // Stack Overflow or Underflow will not cause a Reset.
#define _STVREN_ON              0xFFFF  // Stack Overflow or Underflow will cause a Reset.
#define _BORV_HI                0xFBFF  // Brown-out Reset Voltage (Vbor), high trip point selected.
#define _BORV_LO                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _BORV_19                0xFFFF  // Brown-out Reset Voltage (Vbor), low trip point selected.
#define _LPBOR_ON               0xF7FF  // Low-Power BOR is enabled.
#define _LPBOR_OFF              0xFFFF  // Low-Power BOR is disabled.
#define _LVP_OFF                0xDFFF  // High-voltage on MCLR/VPP must be used for programming.
#define _LVP_ON                 0xFFFF  // Low-voltage programming enabled.

//==============================================================================

#define _DEVID1                 0x8006

#define _IDLOC0                 0x8000
#define _IDLOC1                 0x8001
#define _IDLOC2                 0x8002
#define _IDLOC3                 0x8003

//==============================================================================

#ifndef NO_BIT_DEFINES

#define ADON                    ADCON0bits.ADON                 // bit 0
#define GO_NOT_DONE             ADCON0bits.GO_NOT_DONE          // bit 1, shadows bit in ADCON0bits
#define ADGO                    ADCON0bits.ADGO                 // bit 1, shadows bit in ADCON0bits
#define GO                      ADCON0bits.GO                   // bit 1, shadows bit in ADCON0bits
#define NOT_DONE                ADCON0bits.NOT_DONE             // bit 1, shadows bit in ADCON0bits
#define CHS0                    ADCON0bits.CHS0                 // bit 2
#define CHS1                    ADCON0bits.CHS1                 // bit 3
#define CHS2                    ADCON0bits.CHS2                 // bit 4
#define CHS3                    ADCON0bits.CHS3                 // bit 5
#define CHS4                    ADCON0bits.CHS4                 // bit 6

#define ADPREF0                 ADCON1bits.ADPREF0              // bit 0
#define ADPREF1                 ADCON1bits.ADPREF1              // bit 1
#define ADCS0                   ADCON1bits.ADCS0                // bit 4
#define ADCS1                   ADCON1bits.ADCS1                // bit 5
#define ADCS2                   ADCON1bits.ADCS2                // bit 6
#define ADFM                    ADCON1bits.ADFM                 // bit 7

#define ANSA0                   ANSELAbits.ANSA0                // bit 0
#define ANSA1                   ANSELAbits.ANSA1                // bit 1
#define ANSA2                   ANSELAbits.ANSA2                // bit 2
#define ANSA3                   ANSELAbits.ANSA3                // bit 3
#define ANSA5                   ANSELAbits.ANSA5                // bit 5

#define ANSB0                   ANSELBbits.ANSB0                // bit 0
#define ANSB1                   ANSELBbits.ANSB1                // bit 1
#define ANSB2                   ANSELBbits.ANSB2                // bit 2
#define ANSB3                   ANSELBbits.ANSB3                // bit 3
#define ANSB4                   ANSELBbits.ANSB4                // bit 4
#define ANSB5                   ANSELBbits.ANSB5                // bit 5

#define ABDEN                   BAUD1CONbits.ABDEN              // bit 0
#define WUE                     BAUD1CONbits.WUE                // bit 1
#define BRG16                   BAUD1CONbits.BRG16              // bit 3
#define SCKP                    BAUD1CONbits.SCKP               // bit 4
#define RCIDL                   BAUD1CONbits.RCIDL              // bit 6
#define ABDOVF                  BAUD1CONbits.ABDOVF             // bit 7

#define BORRDY                  BORCONbits.BORRDY               // bit 0
#define BORFS                   BORCONbits.BORFS                // bit 6
#define SBOREN                  BORCONbits.SBOREN               // bit 7

#define BSR0                    BSRbits.BSR0                    // bit 0
#define BSR1                    BSRbits.BSR1                    // bit 1
#define BSR2                    BSRbits.BSR2                    // bit 2
#define BSR3                    BSRbits.BSR3                    // bit 3
#define BSR4                    BSRbits.BSR4                    // bit 4

#define ADFVR0                  FVRCONbits.ADFVR0               // bit 0
#define ADFVR1                  FVRCONbits.ADFVR1               // bit 1
#define TSRNG                   FVRCONbits.TSRNG                // bit 4
#define TSEN                    FVRCONbits.TSEN                 // bit 5
#define FVRRDY                  FVRCONbits.FVRRDY               // bit 6
#define FVREN                   FVRCONbits.FVREN                // bit 7

#define IOCIF                   INTCONbits.IOCIF                // bit 0
#define INTF                    INTCONbits.INTF                 // bit 1
#define TMR0IF                  INTCONbits.TMR0IF               // bit 2, shadows bit in INTCONbits
#define T0IF                    INTCONbits.T0IF                 // bit 2, shadows bit in INTCONbits
#define IOCIE                   INTCONbits.IOCIE                // bit 3
#define INTE                    INTCONbits.INTE                 // bit 4
#define TMR0IE                  INTCONbits.TMR0IE               // bit 5, shadows bit in INTCONbits
#define T0IE                    INTCONbits.T0IE                 // bit 5, shadows bit in INTCONbits
#define PEIE                    INTCONbits.PEIE                 // bit 6
#define GIE                     INTCONbits.GIE                  // bit 7

#define IOCBF0                  IOCBFbits.IOCBF0                // bit 0
#define IOCBF1                  IOCBFbits.IOCBF1                // bit 1
#define IOCBF2                  IOCBFbits.IOCBF2                // bit 2
#define IOCBF3                  IOCBFbits.IOCBF3                // bit 3
#define IOCBF4                  IOCBFbits.IOCBF4                // bit 4
#define IOCBF5                  IOCBFbits.IOCBF5                // bit 5
#define IOCBF6                  IOCBFbits.IOCBF6                // bit 6
#define IOCBF7                  IOCBFbits.IOCBF7                // bit 7

#define IOCBN0                  IOCBNbits.IOCBN0                // bit 0
#define IOCBN1                  IOCBNbits.IOCBN1                // bit 1
#define IOCBN2                  IOCBNbits.IOCBN2                // bit 2
#define IOCBN3                  IOCBNbits.IOCBN3                // bit 3
#define IOCBN4                  IOCBNbits.IOCBN4                // bit 4
#define IOCBN5                  IOCBNbits.IOCBN5                // bit 5
#define IOCBN6                  IOCBNbits.IOCBN6                // bit 6
#define IOCBN7                  IOCBNbits.IOCBN7                // bit 7

#define IOCBP0                  IOCBPbits.IOCBP0                // bit 0
#define IOCBP1                  IOCBPbits.IOCBP1                // bit 1
#define IOCBP2                  IOCBPbits.IOCBP2                // bit 2
#define IOCBP3                  IOCBPbits.IOCBP3                // bit 3
#define IOCBP4                  IOCBPbits.IOCBP4                // bit 4
#define IOCBP5                  IOCBPbits.IOCBP5                // bit 5
#define IOCBP6                  IOCBPbits.IOCBP6                // bit 6
#define IOCBP7                  IOCBPbits.IOCBP7                // bit 7

#define LATA0                   LATAbits.LATA0                  // bit 0
#define LATA1                   LATAbits.LATA1                  // bit 1
#define LATA2                   LATAbits.LATA2                  // bit 2
#define LATA3                   LATAbits.LATA3                  // bit 3
#define LATA4                   LATAbits.LATA4                  // bit 4
#define LATA5                   LATAbits.LATA5                  // bit 5
#define LATA6                   LATAbits.LATA6                  // bit 6
#define LATA7                   LATAbits.LATA7                  // bit 7

#define LATB0                   LATBbits.LATB0                  // bit 0
#define LATB1                   LATBbits.LATB1                  // bit 1
#define LATB2                   LATBbits.LATB2                  // bit 2
#define LATB3                   LATBbits.LATB3                  // bit 3
#define LATB4                   LATBbits.LATB4                  // bit 4
#define LATB5                   LATBbits.LATB5                  // bit 5
#define LATB6                   LATBbits.LATB6                  // bit 6
#define LATB7                   LATBbits.LATB7                  // bit 7

#define LATC0                   LATCbits.LATC0                  // bit 0
#define LATC1                   LATCbits.LATC1                  // bit 1
#define LATC2                   LATCbits.LATC2                  // bit 2
#define LATC3                   LATCbits.LATC3                  // bit 3
#define LATC4                   LATCbits.LATC4                  // bit 4
#define LATC5                   LATCbits.LATC5                  // bit 5
#define LATC6                   LATCbits.LATC6                  // bit 6
#define LATC7                   LATCbits.LATC7                  // bit 7

#define LMUX0                   LCDCONbits.LMUX0                // bit 0
#define LMUX1                   LCDCONbits.LMUX1                // bit 1
#define CS0                     LCDCONbits.CS0                  // bit 2
#define CS1                     LCDCONbits.CS1                  // bit 3
#define WERR                    LCDCONbits.WERR                 // bit 5
#define SLPEN                   LCDCONbits.SLPEN                // bit 6
#define LCDEN                   LCDCONbits.LCDEN                // bit 7

#define LCDCST0                 LCDCSTbits.LCDCST0              // bit 0
#define LCDCST1                 LCDCSTbits.LCDCST1              // bit 1
#define LCDCST2                 LCDCSTbits.LCDCST2              // bit 2

#define SEG0COM0                LCDDATA0bits.SEG0COM0           // bit 0
#define SEG1COM0                LCDDATA0bits.SEG1COM0           // bit 1
#define SEG2COM0                LCDDATA0bits.SEG2COM0           // bit 2
#define SEG3COM0                LCDDATA0bits.SEG3COM0           // bit 3
#define SEG4COM0                LCDDATA0bits.SEG4COM0           // bit 4
#define SEG5COM0                LCDDATA0bits.SEG5COM0           // bit 5
#define SEG6COM0                LCDDATA0bits.SEG6COM0           // bit 6
#define SEG7COM0                LCDDATA0bits.SEG7COM0           // bit 7

#define SEG8COM0                LCDDATA1bits.SEG8COM0           // bit 0
#define SEG9COM0                LCDDATA1bits.SEG9COM0           // bit 1
#define SEG10COM0               LCDDATA1bits.SEG10COM0          // bit 2
#define SEG11COM0               LCDDATA1bits.SEG11COM0          // bit 3
#define SEG12COM0               LCDDATA1bits.SEG12COM0          // bit 4
#define SEG13COM0               LCDDATA1bits.SEG13COM0          // bit 5
#define SEG14COM0               LCDDATA1bits.SEG14COM0          // bit 6
#define SEG15COM0               LCDDATA1bits.SEG15COM0          // bit 7

#define SEG0COM1                LCDDATA3bits.SEG0COM1           // bit 0
#define SEG1COM1                LCDDATA3bits.SEG1COM1           // bit 1
#define SEG2COM1                LCDDATA3bits.SEG2COM1           // bit 2
#define SEG3COM1                LCDDATA3bits.SEG3COM1           // bit 3
#define SEG4COM1                LCDDATA3bits.SEG4COM1           // bit 4
#define SEG5COM1                LCDDATA3bits.SEG5COM1           // bit 5
#define SEG6COM1                LCDDATA3bits.SEG6COM1           // bit 6
#define SEG7COM1                LCDDATA3bits.SEG7COM1           // bit 7

#define SEG8COM1                LCDDATA4bits.SEG8COM1           // bit 0
#define SEG9COM1                LCDDATA4bits.SEG9COM1           // bit 1
#define SEG10COM1               LCDDATA4bits.SEG10COM1          // bit 2
#define SEG11COM1               LCDDATA4bits.SEG11COM1          // bit 3
#define SEG12COM1               LCDDATA4bits.SEG12COM1          // bit 4
#define SEG13COM1               LCDDATA4bits.SEG13COM1          // bit 5
#define SEG14COM1               LCDDATA4bits.SEG14COM1          // bit 6
#define SEG15COM1               LCDDATA4bits.SEG15COM1          // bit 7

#define SEG0COM2                LCDDATA6bits.SEG0COM2           // bit 0
#define SEG1COM2                LCDDATA6bits.SEG1COM2           // bit 1
#define SEG2COM2                LCDDATA6bits.SEG2COM2           // bit 2
#define SEG3COM2                LCDDATA6bits.SEG3COM2           // bit 3
#define SEG4COM2                LCDDATA6bits.SEG4COM2           // bit 4
#define SEG5COM2                LCDDATA6bits.SEG5COM2           // bit 5
#define SEG6COM2                LCDDATA6bits.SEG6COM2           // bit 6
#define SEG7COM2                LCDDATA6bits.SEG7COM2           // bit 7

#define SEG8COM2                LCDDATA7bits.SEG8COM2           // bit 0
#define SEG9COM2                LCDDATA7bits.SEG9COM2           // bit 1
#define SEG10COM2               LCDDATA7bits.SEG10COM2          // bit 2
#define SEG11COM2               LCDDATA7bits.SEG11COM2          // bit 3
#define SEG12COM2               LCDDATA7bits.SEG12COM2          // bit 4
#define SEG13COM2               LCDDATA7bits.SEG13COM2          // bit 5
#define SEG14COM2               LCDDATA7bits.SEG14COM2          // bit 6
#define SEG15COM2               LCDDATA7bits.SEG15COM2          // bit 7

#define SEG0COM3                LCDDATA9bits.SEG0COM3           // bit 0
#define SEG1COM3                LCDDATA9bits.SEG1COM3           // bit 1
#define SEG2COM3                LCDDATA9bits.SEG2COM3           // bit 2
#define SEG3COM3                LCDDATA9bits.SEG3COM3           // bit 3
#define SEG4COM3                LCDDATA9bits.SEG4COM3           // bit 4
#define SEG5COM3                LCDDATA9bits.SEG5COM3           // bit 5
#define SEG6COM3                LCDDATA9bits.SEG6COM3           // bit 6
#define SEG7COM3                LCDDATA9bits.SEG7COM3           // bit 7

#define SEG8COM3                LCDDATA10bits.SEG8COM3          // bit 0
#define SEG9COM3                LCDDATA10bits.SEG9COM3          // bit 1
#define SEG10COM3               LCDDATA10bits.SEG10COM3         // bit 2
#define SEG11COM3               LCDDATA10bits.SEG11COM3         // bit 3
#define SEG12COM3               LCDDATA10bits.SEG12COM3         // bit 4
#define SEG13COM3               LCDDATA10bits.SEG13COM3         // bit 5
#define SEG14COM3               LCDDATA10bits.SEG14COM3         // bit 6
#define SEG15COM3               LCDDATA10bits.SEG15COM3         // bit 7

#define SEG24COM0               LCDDATA12bits.SEG24COM0         // bit 0
#define SEG25COM0               LCDDATA12bits.SEG25COM0         // bit 1
#define SEG26COM0               LCDDATA12bits.SEG26COM0         // bit 2

#define SEG24COM1               LCDDATA15bits.SEG24COM1         // bit 0
#define SEG25COM1               LCDDATA15bits.SEG25COM1         // bit 1
#define SEG26COM1               LCDDATA15bits.SEG26COM1         // bit 2

#define SEG24COM2               LCDDATA18bits.SEG24COM2         // bit 0
#define SEG25COM2               LCDDATA18bits.SEG25COM2         // bit 1
#define SEG26COM2               LCDDATA18bits.SEG26COM2         // bit 2

#define SEG24COM3               LCDDATA21bits.SEG24COM3         // bit 0
#define SEG25COM3               LCDDATA21bits.SEG25COM3         // bit 1
#define SEG26COM3               LCDDATA21bits.SEG26COM3         // bit 2

#define LP0                     LCDPSbits.LP0                   // bit 0
#define LP1                     LCDPSbits.LP1                   // bit 1
#define LP2                     LCDPSbits.LP2                   // bit 2
#define LP3                     LCDPSbits.LP3                   // bit 3
#define WA                      LCDPSbits.WA                    // bit 4
#define LCDA                    LCDPSbits.LCDA                  // bit 5
#define BIASMD                  LCDPSbits.BIASMD                // bit 6
#define WFT                     LCDPSbits.WFT                   // bit 7

#define VLCD1PE                 LCDREFbits.VLCD1PE              // bit 1
#define VLCD2PE                 LCDREFbits.VLCD2PE              // bit 2
#define VLCD3PE                 LCDREFbits.VLCD3PE              // bit 3
#define LCDIRI                  LCDREFbits.LCDIRI               // bit 5
#define LCDIRE                  LCDREFbits.LCDIRE               // bit 7

#define LRLAT0                  LCDRLbits.LRLAT0                // bit 0
#define LRLAT1                  LCDRLbits.LRLAT1                // bit 1
#define LRLAT2                  LCDRLbits.LRLAT2                // bit 2
#define LRLBP0                  LCDRLbits.LRLBP0                // bit 4
#define LRLBP1                  LCDRLbits.LRLBP1                // bit 5
#define LRLAP0                  LCDRLbits.LRLAP0                // bit 6
#define LRLAP1                  LCDRLbits.LRLAP1                // bit 7

#define SE0                     LCDSE0bits.SE0                  // bit 0
#define SE1                     LCDSE0bits.SE1                  // bit 1
#define SE2                     LCDSE0bits.SE2                  // bit 2
#define SE3                     LCDSE0bits.SE3                  // bit 3
#define SE4                     LCDSE0bits.SE4                  // bit 4
#define SE5                     LCDSE0bits.SE5                  // bit 5
#define SE6                     LCDSE0bits.SE6                  // bit 6
#define SE7                     LCDSE0bits.SE7                  // bit 7

#define SE8                     LCDSE1bits.SE8                  // bit 0
#define SE9                     LCDSE1bits.SE9                  // bit 1
#define SE10                    LCDSE1bits.SE10                 // bit 2
#define SE11                    LCDSE1bits.SE11                 // bit 3
#define SE12                    LCDSE1bits.SE12                 // bit 4
#define SE13                    LCDSE1bits.SE13                 // bit 5
#define SE14                    LCDSE1bits.SE14                 // bit 6
#define SE15                    LCDSE1bits.SE15                 // bit 7

#define SE24                    LCDSE3bits.SE24                 // bit 0
#define SE25                    LCDSE3bits.SE25                 // bit 1
#define SE26                    LCDSE3bits.SE26                 // bit 2

#define PS0                     OPTION_REGbits.PS0              // bit 0
#define PS1                     OPTION_REGbits.PS1              // bit 1
#define PS2                     OPTION_REGbits.PS2              // bit 2
#define PSA                     OPTION_REGbits.PSA              // bit 3
#define TMR0SE                  OPTION_REGbits.TMR0SE           // bit 4, shadows bit in OPTION_REGbits
#define T0SE                    OPTION_REGbits.T0SE             // bit 4, shadows bit in OPTION_REGbits
#define TMR0CS                  OPTION_REGbits.TMR0CS           // bit 5, shadows bit in OPTION_REGbits
#define T0CS                    OPTION_REGbits.T0CS             // bit 5, shadows bit in OPTION_REGbits
#define INTEDG                  OPTION_REGbits.INTEDG           // bit 6
#define NOT_WPUEN               OPTION_REGbits.NOT_WPUEN        // bit 7

#define SCS0                    OSCCONbits.SCS0                 // bit 0
#define SCS1                    OSCCONbits.SCS1                 // bit 1
#define IRCF0                   OSCCONbits.IRCF0                // bit 3
#define IRCF1                   OSCCONbits.IRCF1                // bit 4
#define IRCF2                   OSCCONbits.IRCF2                // bit 5
#define IRCF3                   OSCCONbits.IRCF3                // bit 6

#define HFIOFS                  OSCSTATbits.HFIOFS              // bit 0
#define LFIOFR                  OSCSTATbits.LFIOFR              // bit 1
#define HFIOFR                  OSCSTATbits.HFIOFR              // bit 4
#define OSTS                    OSCSTATbits.OSTS                // bit 5
#define T1OSCR                  OSCSTATbits.T1OSCR              // bit 7

#define NOT_BOR                 PCONbits.NOT_BOR                // bit 0
#define NOT_POR                 PCONbits.NOT_POR                // bit 1
#define NOT_RI                  PCONbits.NOT_RI                 // bit 2
#define NOT_RMCLR               PCONbits.NOT_RMCLR              // bit 3
#define NOT_RWDT                PCONbits.NOT_RWDT               // bit 4
#define STKUNF                  PCONbits.STKUNF                 // bit 6
#define STKOVF                  PCONbits.STKOVF                 // bit 7

#define TMR1IE                  PIE1bits.TMR1IE                 // bit 0
#define TXIE                    PIE1bits.TXIE                   // bit 4
#define RCIE                    PIE1bits.RCIE                   // bit 5
#define ADIE                    PIE1bits.ADIE                   // bit 6
#define TMR1GIE                 PIE1bits.TMR1GIE                // bit 7

#define LCDIE                   PIE2bits.LCDIE                  // bit 2

#define TMR1IF                  PIR1bits.TMR1IF                 // bit 0
#define TXIF                    PIR1bits.TXIF                   // bit 4
#define RCIF                    PIR1bits.RCIF                   // bit 5
#define ADIF                    PIR1bits.ADIF                   // bit 6
#define TMR1GIF                 PIR1bits.TMR1GIF                // bit 7

#define LCDIF                   PIR2bits.LCDIF                  // bit 2

#define RD                      PMCON1bits.RD                   // bit 0
#define WR                      PMCON1bits.WR                   // bit 1
#define WREN                    PMCON1bits.WREN                 // bit 2
#define WRERR                   PMCON1bits.WRERR                // bit 3
#define FREE                    PMCON1bits.FREE                 // bit 4
#define LWLO                    PMCON1bits.LWLO                 // bit 5
#define CFGS                    PMCON1bits.CFGS                 // bit 6

#define RA0                     PORTAbits.RA0                   // bit 0
#define RA1                     PORTAbits.RA1                   // bit 1
#define RA2                     PORTAbits.RA2                   // bit 2
#define RA3                     PORTAbits.RA3                   // bit 3
#define RA4                     PORTAbits.RA4                   // bit 4
#define RA5                     PORTAbits.RA5                   // bit 5
#define RA6                     PORTAbits.RA6                   // bit 6
#define RA7                     PORTAbits.RA7                   // bit 7

#define RB0                     PORTBbits.RB0                   // bit 0
#define RB1                     PORTBbits.RB1                   // bit 1
#define RB2                     PORTBbits.RB2                   // bit 2
#define RB3                     PORTBbits.RB3                   // bit 3
#define RB4                     PORTBbits.RB4                   // bit 4
#define RB5                     PORTBbits.RB5                   // bit 5
#define RB6                     PORTBbits.RB6                   // bit 6
#define RB7                     PORTBbits.RB7                   // bit 7

#define RC0                     PORTCbits.RC0                   // bit 0
#define RC1                     PORTCbits.RC1                   // bit 1
#define RC2                     PORTCbits.RC2                   // bit 2
#define RC3                     PORTCbits.RC3                   // bit 3
#define RC4                     PORTCbits.RC4                   // bit 4
#define RC5                     PORTCbits.RC5                   // bit 5
#define RC6                     PORTCbits.RC6                   // bit 6
#define RC7                     PORTCbits.RC7                   // bit 7

#define RE3                     PORTEbits.RE3                   // bit 3

#define RX9D                    RC1STAbits.RX9D                 // bit 0
#define OERR                    RC1STAbits.OERR                 // bit 1
#define FERR                    RC1STAbits.FERR                 // bit 2
#define ADDEN                   RC1STAbits.ADDEN                // bit 3
#define CREN                    RC1STAbits.CREN                 // bit 4
#define SREN                    RC1STAbits.SREN                 // bit 5
#define RX9                     RC1STAbits.RX9                  // bit 6
#define SPEN                    RC1STAbits.SPEN                 // bit 7

#define BRG8                    SP1BRGHbits.BRG8                // bit 0
#define BRG9                    SP1BRGHbits.BRG9                // bit 1
#define BRG10                   SP1BRGHbits.BRG10               // bit 2
#define BRG11                   SP1BRGHbits.BRG11               // bit 3
#define BRG12                   SP1BRGHbits.BRG12               // bit 4
#define BRG13                   SP1BRGHbits.BRG13               // bit 5
#define BRG14                   SP1BRGHbits.BRG14               // bit 6
#define BRG15                   SP1BRGHbits.BRG15               // bit 7

#define BRG0                    SP1BRGLbits.BRG0                // bit 0
#define BRG1                    SP1BRGLbits.BRG1                // bit 1
#define BRG2                    SP1BRGLbits.BRG2                // bit 2
#define BRG3                    SP1BRGLbits.BRG3                // bit 3
#define BRG4                    SP1BRGLbits.BRG4                // bit 4
#define BRG5                    SP1BRGLbits.BRG5                // bit 5
#define BRG6                    SP1BRGLbits.BRG6                // bit 6
#define BRG7                    SP1BRGLbits.BRG7                // bit 7

#define C                       STATUSbits.C                    // bit 0
#define DC                      STATUSbits.DC                   // bit 1
#define Z                       STATUSbits.Z                    // bit 2
#define NOT_PD                  STATUSbits.NOT_PD               // bit 3
#define NOT_TO                  STATUSbits.NOT_TO               // bit 4

#define C_SHAD                  STATUS_SHADbits.C_SHAD          // bit 0
#define DC_SHAD                 STATUS_SHADbits.DC_SHAD         // bit 1
#define Z_SHAD                  STATUS_SHADbits.Z_SHAD          // bit 2

#define TMR1ON                  T1CONbits.TMR1ON                // bit 0
#define NOT_T1SYNC              T1CONbits.NOT_T1SYNC            // bit 2
#define T1OSCEN                 T1CONbits.T1OSCEN               // bit 3
#define T1CKPS0                 T1CONbits.T1CKPS0               // bit 4
#define T1CKPS1                 T1CONbits.T1CKPS1               // bit 5
#define TMR1CS0                 T1CONbits.TMR1CS0               // bit 6
#define TMR1CS1                 T1CONbits.TMR1CS1               // bit 7

#define T1GSS0                  T1GCONbits.T1GSS0               // bit 0
#define T1GSS1                  T1GCONbits.T1GSS1               // bit 1
#define T1GVAL                  T1GCONbits.T1GVAL               // bit 2
#define T1GGO_NOT_DONE          T1GCONbits.T1GGO_NOT_DONE       // bit 3, shadows bit in T1GCONbits
#define T1GGO                   T1GCONbits.T1GGO                // bit 3, shadows bit in T1GCONbits
#define T1GSPM                  T1GCONbits.T1GSPM               // bit 4
#define T1GTM                   T1GCONbits.T1GTM                // bit 5
#define T1GPOL                  T1GCONbits.T1GPOL               // bit 6
#define TMR1GE                  T1GCONbits.TMR1GE               // bit 7

#define TRISA0                  TRISAbits.TRISA0                // bit 0
#define TRISA1                  TRISAbits.TRISA1                // bit 1
#define TRISA2                  TRISAbits.TRISA2                // bit 2
#define TRISA3                  TRISAbits.TRISA3                // bit 3
#define TRISA4                  TRISAbits.TRISA4                // bit 4
#define TRISA5                  TRISAbits.TRISA5                // bit 5
#define TRISA6                  TRISAbits.TRISA6                // bit 6
#define TRISA7                  TRISAbits.TRISA7                // bit 7

#define TRISB0                  TRISBbits.TRISB0                // bit 0
#define TRISB1                  TRISBbits.TRISB1                // bit 1
#define TRISB2                  TRISBbits.TRISB2                // bit 2
#define TRISB3                  TRISBbits.TRISB3                // bit 3
#define TRISB4                  TRISBbits.TRISB4                // bit 4
#define TRISB5                  TRISBbits.TRISB5                // bit 5
#define TRISB6                  TRISBbits.TRISB6                // bit 6
#define TRISB7                  TRISBbits.TRISB7                // bit 7

#define TRISC0                  TRISCbits.TRISC0                // bit 0
#define TRISC1                  TRISCbits.TRISC1                // bit 1
#define TRISC2                  TRISCbits.TRISC2                // bit 2
#define TRISC3                  TRISCbits.TRISC3                // bit 3
#define TRISC4                  TRISCbits.TRISC4                // bit 4
#define TRISC5                  TRISCbits.TRISC5                // bit 5
#define TRISC6                  TRISCbits.TRISC6                // bit 6
#define TRISC7                  TRISCbits.TRISC7                // bit 7

#define TX9D                    TX1STAbits.TX9D                 // bit 0
#define TRMT                    TX1STAbits.TRMT                 // bit 1
#define BRGH                    TX1STAbits.BRGH                 // bit 2
#define SENDB                   TX1STAbits.SENDB                // bit 3
#define SYNC                    TX1STAbits.SYNC                 // bit 4
#define TXEN                    TX1STAbits.TXEN                 // bit 5
#define TX9                     TX1STAbits.TX9                  // bit 6
#define CSRC                    TX1STAbits.CSRC                 // bit 7

#define SWDTEN                  WDTCONbits.SWDTEN               // bit 0
#define WDTPS0                  WDTCONbits.WDTPS0               // bit 1
#define WDTPS1                  WDTCONbits.WDTPS1               // bit 2
#define WDTPS2                  WDTCONbits.WDTPS2               // bit 3
#define WDTPS3                  WDTCONbits.WDTPS3               // bit 4
#define WDTPS4                  WDTCONbits.WDTPS4               // bit 5

#define WPUB0                   WPUBbits.WPUB0                  // bit 0
#define WPUB1                   WPUBbits.WPUB1                  // bit 1
#define WPUB2                   WPUBbits.WPUB2                  // bit 2
#define WPUB3                   WPUBbits.WPUB3                  // bit 3
#define WPUB4                   WPUBbits.WPUB4                  // bit 4
#define WPUB5                   WPUBbits.WPUB5                  // bit 5
#define WPUB6                   WPUBbits.WPUB6                  // bit 6
#define WPUB7                   WPUBbits.WPUB7                  // bit 7

#define WPUE3                   WPUEbits.WPUE3                  // bit 3

#endif // #ifndef NO_BIT_DEFINES

#endif // #ifndef __PIC16LF1906_H__
